<?php

namespace App\Http\Controllers\Frontend\Auth;

use App\Http\Controllers\Controller;
use App\Http\Requests\Frontend\Auth\CodeVerifyRequest;
use App\Http\Requests\Frontend\Auth\ForgotPasswordRequest;
use App\Http\Requests\Frontend\Auth\ResetPasswordRequest;
use App\Services\Frontend\Auth\ForgetPasswordService;

class ForgetPasswordController extends Controller
{
    function forgetPassword(){
        return view('frontend::auth.forget-password');
    }

    function sendVerificationCode(ForgotPasswordRequest $forgotPasswordRequest, ForgetPasswordService $forgetPasswordService){
        $payloads = $forgotPasswordRequest->validated();

        try {
            $response = $forgetPasswordService->sendVerificationCode($payloads);
        } catch (\Throwable $th) {
            return redirect()->back()->with('error', $th->getMessage());
        }

         return redirectAfterOperation($response, 'verify-code');
    }

    function verifyCode(){
        return view('frontend::auth.verify-code');
    }

    function verifyCodeConfirmation(CodeVerifyRequest $codeVerifyRequest, ForgetPasswordService $forgetPasswordService){
        $payloads = $codeVerifyRequest->validated();

        try {

            $response = $forgetPasswordService->codeVerify($payloads);

        } catch (\Throwable $th) {

           return redirect()->route('forgot-password')->with('error', $th->getMessage());
        }

         return redirectAfterOperation($response, 'reset-password');

    }

    function resetPassword(){
        return view('frontend::auth.reset_password');
    }

    function resetPasswordConfirmation(ResetPasswordRequest $resetPasswordRequest, ForgetPasswordService $forgetPasswordService){
        $payloads = $resetPasswordRequest->validated();

        try {
            $response = $forgetPasswordService->resetPassword($payloads);
        } catch (\Throwable $th) {
            return redirect()->back()->with('error', $th->getMessage());
        }

         return redirectAfterOperation($response, 'login');
    }
}
