<?php

namespace App\Http\Controllers\Frontend\Auth;

use App\Http\Controllers\Controller;
use App\Http\Requests\Frontend\Auth\LoginRequest;
use App\Services\Frontend\Auth\LoginService;

class LoginController extends Controller
{
    function login()
    {

        return view('frontend::auth.login');
    }

    function loginStore(LoginRequest $loginRequest, LoginService $loginService)
    {

        $payloads = $loginRequest->validated();

        try {
            $response = $loginService->login($payloads);
        } catch (\Throwable $th) {
            return back()->with('error', $th->getMessage());
        }

        if (session('url.intended')) {
            return redirect()->intended();
        }

        return redirectAfterOperation($response, 'dashboard');
    }
}
