<?php

namespace App\Http\Controllers\Frontend\Auth;

use App\Http\Controllers\Controller;
use App\Http\Requests\Frontend\Auth\RegisterRequest;
use App\Services\Frontend\Auth\RegisterService;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class RegistrationController extends Controller
{
    function registration()
    {
        return view('frontend::auth.registration');
    }

    function registrationStore(RegisterRequest $registerRequest, RegisterService $registerService)
    {
        $payloads = $registerRequest->validated();

        try {
            DB::beginTransaction();

            $response = $registerService->createUser($payloads);

            Auth::loginUsingId($response['user']->id);

            loginLog($response['user']);

            DB::commit();
        } catch (\Throwable $th) {
            return back()->with('error', $th->getMessage());
        }


        return redirectAfterOperation($response, 'dashboard');
    }
}
