<?php

namespace App\Http\Controllers\Frontend\Authorize;

use App\Http\Controllers\Controller;
use App\Http\Requests\Frontend\Authorize\EmailVerifyRequest;
use App\Http\Requests\Frontend\Authorize\KycVerficationRequest;
use App\Models\KycSetting;
use App\Services\Frontend\Authorize\AuthorizationService;
use Illuminate\Support\Facades\DB;

class AuthorizationController extends Controller
{
    function emailVerify()
    {
        return view('frontend::authorization.email_verify');
    }

    function emailVerifyCode(EmailVerifyRequest $emailVerifyRequest, AuthorizationService $authorizationService)
    {
        $payloads = $emailVerifyRequest->validated();

        try {
            $response = $authorizationService->emailVerify($payloads);
        } catch (\Throwable $th) {
            return back()->with('error', $th->getMessage());
        }

        return redirectAfterOperation($response, 'dashboard');
    }

    function smsVerify()
    {
        return view('frontend::authorization.sms_verify');
    }

    function smsVerifyCode(EmailVerifyRequest $emailVerifyRequest,AuthorizationService $authorizationService){
        $payloads = $emailVerifyRequest->validated();

        try {
            $response = $authorizationService->smsVerify($payloads);
        } catch (\Throwable $th) {
            return back()->with('error', $th->getMessage());
        }

        return redirectAfterOperation($response, 'dashboard');
    }

    function kycVerification()
    {
        $payloads['kyc'] = KycSetting::latest()->get();

        return view('frontend::authorization.kyc')->with($payloads);
    }

    function kycVerificationRequest(KycVerficationRequest $kycVerficationRequest, AuthorizationService $authorizationService)
    {
        $payloads = $kycVerficationRequest->validated();

        try {
            DB::beginTransaction();
            
            $response = $authorizationService->kycVerification($payloads);

            DB::commit();
        } catch (\Throwable $th) {
            return back()->with('error', $th->getMessage());
        }

        return redirectAfterOperation($response);
    }
}
