<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use App\Models\Auction;
use App\Models\AuctionPurchase;
use App\Models\IcoSetting;
use App\Models\ReferralCommission;
use App\Models\StagePurchase;
use App\Models\Support;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class DashboardController extends Controller
{
    function dashboard()
    {
        $user = user();
        $data['totalbalance'] = $user->balance;
        $data['totalDeposit'] = $user->deposits()->where('status', 1)->sum('amount');
        $data['totalWithdraw'] = $user->withdraws()->where('status', 1)->sum('withdraw_amount');
        $data['totalSupportTickets'] = $user->supports()->count();
        $data['totalOpenTicket'] = Support::whereUserId(user()->id)->openSupport()->count();
        $data['user'] = $user;
        $data['transactions'] = $user->transactions()->latest()->with('user')->limit(3)->get();
        $data['totalCommission'] = ReferralCommission::where('who_received', $user->id)->sum('amount');
        $data['totalToken'] = $user->token;
        $data['setting'] = IcoSetting::first();
        $data['auctions'] = Auction::active()->where('user_id', '!=', user()->id)->latest()->take(10)->get();
        $data['totalAuction'] = Auction::whereUserId(user()->id)->count();
        $data['totalRunningAuction'] = Auction::active()->whereUserId(user()->id)->count();
        $data['lastPurchaseToken'] = StagePurchase::whereUserId(user()->id)->latest()->first();

        $months = array();


        $data['dates'] = user()->deposits()->select(DB::raw('DATE_FORMAT(created_at, "%d %b") as date'))
            ->union(user()->withdraws()->select(DB::raw('DATE_FORMAT(created_at, "%d %b") as date')))
            ->orderBy(DB::raw('STR_TO_DATE(date, "%d %b")'), 'ASC')
            ->pluck('date');

        $data['auctionDates'] = user()->sales()->select(DB::raw('DATE_FORMAT(created_at, "%d %b") as date'))
            ->union(user()->purchases()->select(DB::raw('DATE_FORMAT(created_at, "%d %b") as date')))
            ->orderBy(DB::raw('STR_TO_DATE(date, "%d %b")'), 'ASC')
            ->pluck('date');



        $data['depositData'] = user()->deposits()->accepted()->select(DB::raw('DATE_FORMAT(created_at, "%d %b") as date'), DB::raw('SUM(amount) as total_deposit'))->groupBy('date')->pluck('total_deposit', 'date');
        $data['withdrawData'] = user()->withdraws()->accepted()->select(DB::raw('DATE_FORMAT(created_at, "%d %b") as date'), DB::raw('SUM(withdraw_amount) as total_withdraw'))->groupBy('date')->pluck('total_withdraw', 'date');

        $data['saleData'] = AuctionPurchase::where('seller_id', user()->id)
            ->select(DB::raw('DATE_FORMAT(created_at, "%d %b") as date'), DB::raw('SUM(tokens) as total_token'))->groupBy('date')->pluck('total_token', 'date');
        $data['purchaseData'] = AuctionPurchase::where('buyer_id', user()->id)
            ->select(DB::raw('DATE_FORMAT(created_at, "%d %b") as date'), DB::raw('SUM(tokens) as total_token'))->groupBy('date')->pluck('total_token', 'date');

        $data['finalDepositData'] = [];
        $data['finalWithdrawData'] = [];
        $data['finalSaleData'] = [];
        $data['finalPurchaseData'] = [];


        foreach ($data['dates'] as $date) {
            $data['finalDepositData'][] = $data['depositData'][$date] ?? 0;
            $data['finalWithdrawData'][] = $data['withdrawData'][$date] ?? 0;
        }

        foreach ($data['auctionDates'] as $d) {
            $data['finalSaleData'][] = $data['saleData'][$d] ?? 0;
            $data['finalPurchaseData'][] = $data['purchaseData'][$d] ?? 0;
        }

        return view('frontend::dashboard')->with($data);
    }

    function logout()
    {
        Auth::logout();

        session()->forget('2fa');

        return to_route('login');
    }
}
