<?php

namespace App\Http\Controllers\Frontend\Deposit;

use App\Factory\PaymentGatewayFactory;
use App\Http\Controllers\Controller;
use App\Http\Requests\Frontend\Deposit\BankRequest;
use App\Http\Requests\Frontend\Deposit\DepositRequest;
use App\Http\Requests\Frontend\Deposit\GatewayRequest;
use App\Models\Deposit;
use App\Models\Gateway;
use App\Services\Frontend\Deposit\DepositService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class DepositController extends Controller
{

    function deposit()
    {
        $payloads['methods'] = Gateway::active()->latest()->get();


        session()->forget('transaction');

        session()->forget('view_returned');

        return view('user::deposit.index')->with($payloads);
    }

    function depositInitiate(GatewayRequest $depositRequest, DepositService $depositService)
    {
        $payloads = $depositRequest->validated();

        session()->forget('view_returned');

        try {
            $response = $depositService->deposit($payloads);
        } catch (\Throwable $th) {
            return back()->with('error', $th->getMessage());
        }

        return redirectAfterOperation($response, 'deposit-overview');
    }

    function depositInstruction(Request $request)
    {
        $payloads['gateway'] = Gateway::findOrFail($request->method);

        return view('user::deposit.fetch-instruction')->with($payloads);
    }

    function depositOverview()
    {
        $transaction = session('transaction');

        if (!$transaction) {
            return redirect()->route('deposit')->with('error', 'Transaction not started.');
        }

        $transaction['gateway'] = Gateway::find(session('transaction')['method_id']);

        session()->forget('view_returned');

        return view('user::deposit.deposit-overview')->with($transaction);
    }

    function depositrequirements()
    {
        $transaction = session('transaction');

        if (!$transaction) {
            return redirect()->route('deposit')->with('error', 'Transaction not started.');
        }

        $transaction['gateway'] = Gateway::findOrFail($transaction['method_id']);

        return view('user::deposit.requirements')->with($transaction);
    }

    function depositConfirmation(BankRequest $bankRequest, DepositService $depositService)
    {
        $transaction = session('transaction');

        $method = Gateway::findOrFail($transaction['method_id']);

        try {
            if ($method->gateway_type == cons()::ONLINE_GATEWAY) {
                $gateway = PaymentGatewayFactory::create(strtolower($method->name));
    
                $response = $gateway->initPayment($method, $transaction);
    
                if ($response['type'] == 'response') {
                    return $response['redirect'];
                }
                return redirect()->to($response['redirect']);
            }
    
            DB::beginTransaction();
            $response = $depositService->offlineConfirmation($bankRequest->validated());
            DB::commit();
        } catch (\Throwable $th) {
            return back()->with('error', $th->getMessage());
        }

        return redirectAfterOperation($response, 'deposit-final');
    }

    function depositFinal()
    {
        $payloads = session('transaction') ?? [];

        if (count($payloads) <= 0) {
            return to_route('deposit')->with('error', tt_trans('Invalid Deposit Request', cons()::LANGUAGE_NOTIFICATION));
        }

        $gateway = Gateway::findOrFail($payloads['method_id']);

        $deposit = Deposit::where('trx', $payloads['trx'])->firstOrFail();

        return view('user::deposit.deposit-final', compact('gateway', 'deposit'));
    }
}
