<?php

namespace App\Http\Controllers\Frontend\Ipn;

use App\Factory\PaymentGatewayFactory;
use App\Http\Controllers\Controller;
use App\Models\Gateway;
use App\Models\GatewayPayment;
use Illuminate\Http\Request;

class IpnController extends Controller
{
    public $gateway;

    public $module;

    function __construct(Request $request)
    {
        $this->gateway = PaymentGatewayFactory::create($request->method ?? 'nowpayments');
    }

    function paymentSuccess()
    {
        $response = $this->gateway->paymentSuccess($this->gateway, session('transaction')['module'], request()->all());

        if (request()->ajax()) {
            if (session('transaction')['module'] == 'deposit') {
                return response()->json([
                    'success' => true,
                    'message' => 'Deposit was successful.',
                    'route' => route('deposit-final')
                ]);
            } else {
                return response()->json([
                    'success' => true,
                    'message' => 'Payment was successful.',
                    'route' => route('payment-final')
                ]);
            }
        }

        return redirectAfterOperation($response, $response['route']);
    }

    function paymentCallback(Request $request)
    {
        $response = $this->gateway->paymentCallback($request, session('transaction'), session('transaction')['module']);

        return redirectAfterOperation($response, $response['route']);
    }

    function paymentCancel()
    {
        $response = $this->gateway->paymentCancel(session('transaction')['module']);

        return redirectAfterOperation($response, $response['route']);
    }

    function paymentCheck(Request $request)
    {
        $response = $this->gateway->paymentCheck($request->all());

        return $response;
    }

    function paymentView(Request $request)
    {
        $payloads['data'] = session('transaction');

        $payloads['user'] = user();

        $payloads['method'] = Gateway::where('name', $request->method)->firstOrFail();

        if ($payloads['method']->is_module) {
            return view(strtolower($payloads['method']->module) . '::gateways.' . $payloads['method']->name)->with($payloads);
        }

        return view('user::gateways.' . $request->method)->with($payloads);
    }

    function cryptoView(Request $request)
    {
        $payloads['cryptoPayment'] = GatewayPayment::where('trx', $request->trx)->firstOrFail();

        return view('user::gateways.crypto')->with($payloads);
    }

    function cryptoPaymentStatus(Request $request)
    {
        $response = $this->gateway->paymentCallback($request, session('transaction'), session('transaction')['module']);

        return response()->json($response);
    }
}
