<?php

namespace App\Http\Controllers\Frontend\Log;

use App\Filters\DateFilter;
use App\Filters\SortFilter;
use App\Filters\TrxFilter;
use App\Http\Controllers\Controller;
use App\Models\Deposit;
use App\Models\Payment;
use App\Models\ReferralCommission;
use App\Models\Transaction;
use App\Models\Withdraw;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class LogController extends Controller
{
    function withdrawLog()
    {
        $withdraws = Withdraw::select('*', DB::raw('DATE(created_at) as date'))
            ->myWithdraw()
            ->latest()
            ->filter([TrxFilter::class, SortFilter::class, DateFilter::class])
            ->paginate(offsetPerPage());

        // Group the paginated collection by 'date'
        $groupedwithdraws = $withdraws->getCollection()->groupBy('date');
        $payloads['withdraws'] = $withdraws->setCollection($groupedwithdraws);

        $payloads['total_withdraws'] = Withdraw::myWithdraw()->count();

        return view('user::logs.withdraw')->with($payloads);
    }

    function transactionLog()
    {
        $transactions = Transaction::select('*', DB::raw('DATE(created_at) as date'))
            ->myTransaction()
            ->latest()
            ->filter([TrxFilter::class, SortFilter::class, DateFilter::class])
            ->paginate(offsetPerPage());

        $groupedtransactions = $transactions->getCollection()->groupBy('date');
        $payloads['transactions'] = $transactions->setCollection($groupedtransactions);

        $payloads['total_transactions'] = Transaction::myTransaction()->count();

        return view('user::logs.transaction')->with($payloads);
    }

    function depositLog()
    {
        $deposits = Deposit::select('*', DB::raw('DATE(created_at) as date'))
            ->myDeposit()
            ->latest()
            ->filter([TrxFilter::class, SortFilter::class, DateFilter::class])
            ->paginate(offsetPerPage());

        $groupeddeposits = $deposits->getCollection()->groupBy('date');
        $payloads['deposits'] = $deposits->setCollection($groupeddeposits);

        $payloads['total_deposits'] = Deposit::myDeposit()->count();

        return view('user::logs.deposit')->with($payloads);
    }


    function paymentLog(){
        $payments = Payment::select('*', DB::raw('DATE(created_at) as date'))
            ->myPayment()
            ->latest()
            ->filter([TrxFilter::class, SortFilter::class, DateFilter::class])
            ->paginate(offsetPerPage());

        $groupedpayments = $payments->getCollection()->groupBy('date');
        $payloads['payments'] = $payments->setCollection($groupedpayments);

        $payloads['total_payments'] = Payment::myPayment()->count();

        return view('user::logs.payment')->with($payloads);
    }

    function fetchDetails(Request $request)
    {
        if ($request->type == 'withdraw') {
            $title = 'Withdraw Details';
            $details = Withdraw::find($request->id);
            return view('user::logs.withdraw_details', compact('details', 'title'));
        } elseif ($request->type == 'deposit') {
            $title = 'Deposit Details';
            $details = Deposit::find($request->id);
            return view('user::logs.deposit_details', compact('details', 'title'));
        } elseif ($request->type == 'transaction') {
            $title = 'Transaction Details';
            $details = Transaction::find($request->id);
            return view('user::logs.transaction_details', compact('details', 'title'));
        } elseif ($request->type == 'commission') {
            $title = 'Commission Details';
            $details = ReferralCommission::find($request->id);
            return view('user::logs.commission_details', compact('details', 'title'));
        }elseif ($request->type == 'payment') {
            $title = 'Payment Details';
            $details = Payment::find($request->id);
            return view('user::logs.payment_details', compact('details', 'title'));
        }
    }

    function referralCommissionLog()
    {
        $commissions = ReferralCommission::select('*', DB::raw('DATE(created_at) as date'))
            ->myCommissions()
            ->latest()
            ->filter([TrxFilter::class, DateFilter::class])
            ->paginate(offsetPerPage());

        $groupedcommissions = $commissions->getCollection()->groupBy('date');
        $payloads['commissions'] = $commissions->setCollection($groupedcommissions);

        $payloads['commissions_total'] = ReferralCommission::myCommissions()->count();

        return view('user::logs.commission')->with($payloads);
    }
}
