<?php

namespace App\Http\Controllers\Frontend\Profile;

use App\Http\Controllers\Controller;
use App\Http\Requests\Frontend\Profile\UpdateAddressRequest;
use App\Http\Requests\Frontend\Profile\UpdateProfileImageRequest;
use App\Http\Requests\Frontend\Profile\UpdateProfileRequest;
use App\Http\Requests\Frontend\Profile\UpdateUserPasswordRequest;
use App\Services\Frontend\Profile\ProfileService;

class UserProfileController extends Controller
{
    function profile()
    {
        return view('user::profile.index');
    }

    function profileImageUpdate(UpdateProfileImageRequest $updateProfileImageRequest, ProfileService $profileService)
    {
        $payloads = $updateProfileImageRequest->validated();

        try {
            $response = $profileService->updateProfileImage($payloads);
        } catch (\Throwable $th) {
            return back()->with('error', $th->getMessage());
        }

        return redirectAfterOperation($response);
    }

    function profileUpdate(UpdateProfileRequest $updateProfileRequest, ProfileService $profileService){
        $payloads = $updateProfileRequest->validated();

        try {
            $response = $profileService->updateProfile($payloads);
        } catch (\Throwable $th) {
            return back()->with('error', $th->getMessage());
        }

        return redirectAfterOperation($response);
    }

    function profileAddress(UpdateAddressRequest $updateAddressRequest, ProfileService $profileService){
        $payloads = $updateAddressRequest->validated();

        try {
            $response = $profileService->updateAddress($payloads);
        } catch (\Throwable $th) {
            return back()->with('error', $th->getMessage());
        }

        return redirectAfterOperation($response);
    }

    function updatePassword(UpdateUserPasswordRequest $updateUserPasswordRequest, ProfileService $profileService){
        
        $payloads = $updateUserPasswordRequest->validated();

        try {
            $response = $profileService->updatePassword($payloads);
        } catch (\Throwable $th) {
            return back()->with('error', $th->getMessage());
        }

        return redirectAfterOperation($response);
    }
}
