<?php

namespace App\Http\Controllers\Frontend\Referral;

use App\Http\Controllers\Controller;
use App\Http\Requests\Frontend\Referral\SendReferralRequest;
use App\Services\Frontend\Referral\ReferralService;

class ReferralController extends Controller
{
    function referral()
    {
        $payloads['shareComponent'] = \Share::page(
            route('registration',user()->username),
            'Share Link',
        )
            ->facebook()
            ->twitter()
            ->linkedin()
            ->telegram()
            ->whatsapp()
            ->reddit();

        $payloads['user'] = user();

            
        return view('user::referral.index')->with($payloads);
    }

    function sendReferralLink(SendReferralRequest $sendReferralRequest, ReferralService $referralService)
    {
        $payloads = $sendReferralRequest->validated();

        try {
            $response = $referralService->sendInvitationLink($payloads);
        } catch (\Throwable $th) {
            return back()->with('error', $th->getMessage());
        }

        return redirectAfterOperation($response);
    }
}
