<?php

namespace App\Http\Controllers\Frontend\Socialite;

use App\Http\Controllers\Controller;
use App\Models\User;
use App\Models\UserAbility;
use App\Models\UserAddress;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\DB;
use Laravel\Socialite\Facades\Socialite;

class FacebookLoginController extends Controller
{
    public function redirectToFacebook()
    {
        config([
            'services.facebook.client_id' => tc()->get('facebook_app_id'),
            'services.facebook.client_secret' => tc()->get('facebook_app_secret'),
            'services.facebook.redirect' => request()->root().'/'.tc()->get('facebook_callback'),
        ]);

        return Socialite::driver('facebook')->redirect();
    }

    public function handleFacebookCallback(Request $request)
    {
        config([
            'services.facebook.client_id' => tc()->get('facebook_app_id'),
            'services.facebook.client_secret' => tc()->get('facebook_app_secret'),
            'services.facebook.redirect' => request()->root().'/'.tc()->get('facebook_callback'),
        ]);

        if ($request->has('error') && $request->get('error') == 'access_denied') {
            return to_route('login')->with('error', 'You have canceled the authentication process.');
        }

        try {
            DB::beginTransaction();

            $facebookUser = Socialite::driver('facebook')->stateless()->user();

            $user = User::updateOrCreate(
                [
                    'email' => $facebookUser->email,
                ],
                [
                    'username' => Str::slug($facebookUser->name),
                    'email' => $facebookUser->email,
                    'facebook_id' => $facebookUser->id,
                ],
            );

            UserAbility::updateOrCreate(
                [
                    'user_id' => $user->id,
                ],
                [
                    'status' => cons()::ACTIVE,
                    'email_verified' => cons()::ACTIVE,
                ],
            );

            UserAddress::updateOrCreate(
                [
                    'user_id' => $user->id,
                ],
                ['user_id' => $user->id],
            );

            DB::commit();

            Auth::login($user);
        } catch (\Throwable $th) {
            return back()->with('error', $th->getMessage());
        }

        return to_route('dashboard');
    }
}
