<?php

namespace App\Http\Controllers\Frontend\Socialite;

use App\Http\Controllers\Controller;
use App\Models\User;
use App\Models\UserAbility;
use App\Models\UserAddress;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use Laravel\Socialite\Facades\Socialite;

class GoogleLoginController extends Controller
{
    public function redirectToGoogle()
    {
        config([
            'services.google.client_id' => tc()->get('google_app_id'),
            'services.google.client_secret' => tc()->get('google_app_secret'),
            'services.google.redirect' => request()->root().'/'.tc()->get('google_callback'),
        ]);

        return Socialite::driver('google')->redirect();
    }

    public function handleGoogleCallback(Request $request)
    {
        config([
            'services.google.client_id' => tc()->get('google_app_id'),
            'services.google.client_secret' => tc()->get('google_app_secret'),
            'services.google.redirect' => request()->root().'/'.tc()->get('google_callback'),
        ]);

        if ($request->has('error') && $request->get('error') == 'access_denied') {
            return to_route('login')->with('error', 'You have canceled the authentication process.');
        }

        try {
            DB::beginTransaction();

            $googleUser = Socialite::driver('google')->stateless()->user();

            $user = User::updateOrCreate(
                [
                    'email' => $googleUser->email,
                ],
                [
                    'username' => Str::slug($googleUser->name),
                    'email' => $googleUser->email,
                    'google_id' => $googleUser->id,
                ],
            );

            UserAbility::updateOrCreate(
                [
                    'user_id' => $user->id,
                ],
                [
                    'status' => cons()::ACTIVE,
                    'email_verified' => cons()::ACTIVE,
                ],
            );

            UserAddress::updateOrCreate(
                [
                    'user_id' => $user->id,
                ],
                ['user_id' => $user->id],
            );

            DB::commit();

            Auth::login($user);
        } catch (\Throwable $th) {
            return back()->with('error', $th->getMessage());
        }

        return to_route('dashboard');
    }
}
