<?php

namespace App\Http\Controllers\Frontend\Support;

use App\Filters\SortFilter;
use App\Filters\TrxFilter;
use App\Http\Controllers\Controller;
use App\Http\Requests\Frontend\Support\StoreReplyRequest;
use App\Http\Requests\Frontend\Support\StoreRequest;
use App\Models\Support;
use App\Models\SupportFile;
use App\Services\Frontend\Support\SupportService;
use Illuminate\Support\Facades\DB;

class SupportController extends Controller
{
    function index()
    {
        $payloads['supports'] = Support::where('user_id', user()->id)->latest()->filter([TrxFilter::class,SortFilter::class])->paginate(offsetPerPage());

        return view('user::support.index')->with($payloads);
    }

    function create()
    {
        return view('user::support.create');
    }

    function store(StoreRequest $storeRequest, SupportService $supportService)
    {
        $payloads = $storeRequest->validated();

        try {
            DB::beginTransaction();
            $response = $supportService->createSupport($payloads);
            DB::commit();
        } catch (\Throwable $th) {
            return back()->with('error', $th->getMessage());
        }

        return redirectAfterOperation($response,'support.index');
    }

    function show(Support $support){
       return view('user::support.details',compact('support'));
    }

    function supportDownload(SupportFile $supportFile){
       
        $path = cons()::IMAGE_UPLOAD_ROOT_PATH.'support/'.$supportFile->file;

        if (!file_exists($path)) {
            return back()->with('error', tt_trans('File Not Found', cons()::LANGUAGE_NOTIFICATION));
        }

        return response()->download($path);

    }

    function supportReply(StoreReplyRequest $storeReplyRequest, SupportService $supportService, Support $support){

        $payloads = $storeReplyRequest->validated();

        try {
            $response = $supportService->storeReply($payloads, $support);
        } catch (\Throwable $th) {
            return back()->with('error', $th->getMessage());
        }

        return redirectAfterOperation($response);
    }
}
