<?php

namespace App\Http\Controllers\Frontend\TwoFA;

use App\Http\Controllers\Controller;
use App\Http\Requests\Frontend\TwoFa\TwoFaRequest;
use App\Services\Frontend\TwoFa\TwoFaService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;


class TwoFAAuthenticationController extends Controller
{
    function twoFactor(TwoFaService $twoFaService){
         $payloads = $twoFaService->generateQrCode();
        return view('user::2fa.qrcode')->with($payloads);
    }

    function enableTwoFa(TwoFaRequest $twoFaRequest, TwoFaService $twoFaService){
        
        $payloads = $twoFaRequest->validated();

        try {
            $response = $twoFaService->enableTwoFa($payloads);
        } catch (\Throwable $th) {
            return back()->with('error', $th->getMessage());
        }

        return redirectAfterOperation($response,'authentication');
    }


    function authentication(){
        return view('user::2fa.index');
    }

    function verifyOtp(TwoFaRequest $twoFaRequest, TwoFaService $twoFaService){

        $payloads = $twoFaRequest->validated();

        try {
            $response = $twoFaService->verifyOtp($payloads);
        } catch (\Throwable $th) {
            return back()->with('error', $th->getMessage());
        }

        return redirectAfterOperation($response,'dashboard');
    }

    function disableTwoFactorAuthentication(TwoFaRequest $twoFaRequest, TwoFaService $twoFaService){

        $payloads = $twoFaRequest->validated();

        try {
            $response = $twoFaService->disableTwoFactorAuthentication($payloads);
        } catch (\Throwable $th) {
            return back()->with('error', $th->getMessage());
        }

        return redirectAfterOperation($response,'dashboard');


       

        return to_route('dashboard')->with('success',tt_trans('2Fa authentication removed successfully',cons()::LANGUAGE_NOTIFICATION));


    }
}
