<?php

namespace App\Http\Controllers\Frontend\Withdraw;

use App\Http\Controllers\Controller;
use App\Http\Requests\Frontend\Withdraw\WithdrawRequest;
use App\Models\WithdrawMethod;
use App\Services\Frontend\Withdraw\WithdrawService;
use Illuminate\Support\Facades\DB;

class WithdrawController extends Controller
{
    function withdraw(){
        $payloads['methods'] = WithdrawMethod::latest()->active()->get();

        session()->forget('withdraw');

        if($payloads['methods']->count() <= 0){
            return back()->with('error',tt_trans('No Withdraw method available', cons()::LANGUAGE_NOTIFICATION));
        }


        return view('user::withdraw.index')->with($payloads);
    }

    function fetchWithdrawInstruction($id){

        $method = WithdrawMethod::findOrFail($id);

        return view('user::withdraw.fetch_withdraw_info',compact('method'));
        
    }

    function makeWithdraw(WithdrawRequest $withdrawRequest, WithdrawService $withdrawService){
        $payloads = $withdrawRequest->validated();

        try {
            $response = $withdrawService->makeWithdraw($payloads);
        } catch (\Throwable $th) {
            return back()->with('error', $th->getMessage());
        }

        return redirectAfterOperation($response,'withdraw-overview');
    }

    function withdrawOverview(){
        $payloads = session('withdraw') ?? [];


        if(count($payloads) <= 0){
            return to_route('withdraw')->with('error',tt_trans('Invalid Withdraw Request',cons()::LANGUAGE_NOTIFICATION));
        }
        
        return view('user::withdraw.overview');
    }

    function withdrawFinal(){

        $payloads = session('withdraw') ?? [];


        if(count($payloads) <= 0){
            return to_route('withdraw')->with('error',tt_trans('Invalid Withdraw Request',cons()::LANGUAGE_NOTIFICATION));
        }

        return view('user::withdraw.final');
    }


    function withdrawConfirmation(WithdrawService $withdrawService){

        try {
            DB::beginTransaction();
            $response = $withdrawService->confirmWithdraw();
            DB::commit();
        } catch (\Throwable $th) {
            return back()->with('error', $th->getMessage());
        }

        return redirectAfterOperation($response,'withdraw-final');
    }

}
