<?php

namespace App\Http;

use App\Http\Middleware\AdminIsActive;
use App\Http\Middleware\ApplyTheme;
use App\Http\Middleware\CookieConsent;
use App\Http\Middleware\IsActive;
use App\Http\Middleware\IsAdminLoggedIn;
use App\Http\Middleware\IsAdminNotLoggedIn;
use App\Http\Middleware\IsEmailAuthorize;
use App\Http\Middleware\IsEmailVerified;
use App\Http\Middleware\IsInstalled;
use App\Http\Middleware\IsKycAuthorize;
use App\Http\Middleware\IsKycVerified;
use App\Http\Middleware\IsRegistrationInactive;
use App\Http\Middleware\IsSendCodeAlready;
use App\Http\Middleware\IsSmsAuthorize;
use App\Http\Middleware\IsSmsVerified;
use App\Http\Middleware\IsTwoFaEnable;
use App\Http\Middleware\LanguageMiddleware;
use App\Http\Middleware\MaintananceMode;
use App\Http\Middleware\MaintananceModeOff;
use App\Http\Middleware\NotInstalled;
use App\Http\Middleware\RestrictionRequestMiddleware;
use Illuminate\Foundation\Http\Kernel as HttpKernel;
use Spatie\Permission\Middleware\PermissionMiddleware;

class Kernel extends HttpKernel
{
    /**
     * The application's global HTTP middleware stack.
     *
     * These middleware are run during every request to your application.
     *
     * @var array<int, class-string|string>
     */
    protected $middleware = [
        // \App\Http\Middleware\TrustHosts::class,
        \App\Http\Middleware\TrustProxies::class,
        \Illuminate\Http\Middleware\HandleCors::class,
        \App\Http\Middleware\PreventRequestsDuringMaintenance::class,
        \Illuminate\Foundation\Http\Middleware\ValidatePostSize::class,
        \App\Http\Middleware\TrimStrings::class,
        \Illuminate\Foundation\Http\Middleware\ConvertEmptyStringsToNull::class,
        CookieConsent::class
    ];

    /**
     * The application's route middleware groups.
     *
     * @var array<string, array<int, class-string|string>>
     */
    protected $middlewareGroups = [
        'web' => [
            \App\Http\Middleware\EncryptCookies::class,
            \Illuminate\Cookie\Middleware\AddQueuedCookiesToResponse::class,
            \Illuminate\Session\Middleware\StartSession::class,
            \Illuminate\View\Middleware\ShareErrorsFromSession::class,
            \App\Http\Middleware\VerifyCsrfToken::class,
            \Illuminate\Routing\Middleware\SubstituteBindings::class,
            LanguageMiddleware::class,
            ApplyTheme::class

        ],

        'api' => [
            // \Laravel\Sanctum\Http\Middleware\EnsureFrontendRequestsAreStateful::class,
            \Illuminate\Routing\Middleware\ThrottleRequests::class.':api',
            \Illuminate\Routing\Middleware\SubstituteBindings::class,
        ],
    ];

    /**
     * The application's middleware aliases.
     *
     * Aliases may be used instead of class names to conveniently assign middleware to routes and groups.
     *
     * @var array<string, class-string|string>
     */
    protected $middlewareAliases = [
        'auth' => \App\Http\Middleware\Authenticate::class,
        'auth.basic' => \Illuminate\Auth\Middleware\AuthenticateWithBasicAuth::class,
        'auth.session' => \Illuminate\Session\Middleware\AuthenticateSession::class,
        'cache.headers' => \Illuminate\Http\Middleware\SetCacheHeaders::class,
        'can' => \Illuminate\Auth\Middleware\Authorize::class,
        'guest' => \App\Http\Middleware\RedirectIfAuthenticated::class,
        'password.confirm' => \Illuminate\Auth\Middleware\RequirePassword::class,
        'precognitive' => \Illuminate\Foundation\Http\Middleware\HandlePrecognitiveRequests::class,
        'signed' => \App\Http\Middleware\ValidateSignature::class,
        'throttle' => \Illuminate\Routing\Middleware\ThrottleRequests::class,
        'verified' => \Illuminate\Auth\Middleware\EnsureEmailIsVerified::class,
        'is_not_admin' => IsAdminNotLoggedIn::class,
        'is_admin' => IsAdminLoggedIn::class,
        'is_admin_active' => AdminIsActive::class,
        'is_send_code_already' => IsSendCodeAlready::class,
        'permission' => PermissionMiddleware::class,
        'is_active' => IsActive::class,
        'is_email_verified' => IsEmailVerified::class,
        'is_sms_verified' => IsSmsVerified::class,
        'is_kyc_verified' => IsKycVerified::class,
        'is_email_authorize' => IsEmailAuthorize::class,
        'is_sms_authorize' => IsSmsAuthorize::class,
        'is_kyc_authorize' => IsKycAuthorize::class,
        'is_reg_off' => IsRegistrationInactive::class,
        'is_two_fa_enable' => IsTwoFaEnable::class,
        'maintanance_mode' => MaintananceMode::class,
        'maintanance_mode_off' => MaintananceModeOff::class,
        'demo' => RestrictionRequestMiddleware::class,
        'is_installed' => IsInstalled::class,
        'is_not_installed' => NotInstalled::class
    ];
}
