<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;

class AdminIsActive
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {

        if(!admin()->status){
            
            Auth::guard('admin')->logout(admin()->id);

            return to_route('panel.login')->with('error', tt_trans('Your Account is inactive',cons()::LANGUAGE_NOTIFICATION));
        }

        return $next($request);
    }
}
