<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class CookieConsent
{
    public function handle(Request $request, Closure $next)
    {
        // Check if the user has accepted or rejected cookies
        if (!$request->cookie('cookie_consent')) {
            // Pass a variable to the view to show the consent banner
            view()->share('showCookieConsent', true);
        } else {
            view()->share('showCookieConsent', false);
        }

        return $next($request);
    }
}

