<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;

class IsActive
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        if(!user()->ability->status){
            Auth::logout();

            return redirect()->route('login')->with('error', tt_trans('Your account is inactive',cons()::LANGUAGE_NOTIFICATION));
        }

        return $next($request);
    }
}
