<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class IsKycAuthorize
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $user = user();

        if($user->ability->kyc_verified == cons()::ACTIVE || !tc()->get('kyc_ver')){
            return to_route('dashboard');
        }


        return $next($request);
    }
}
