<?php

namespace App\Http\Middleware;

use App\Models\KycSetting;
use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class IsKycVerified
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $settings = KycSetting::count();

        if(auth()->check() && user()->ability->kyc_verified != cons()::ACTIVE && tc()->get('kyc_ver') && $settings > 0) {
            return to_route('kyc-verification');
        }
        return $next($request);
    }
}
