<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;
use Symfony\Component\HttpFoundation\Response;

class IsSendCodeAlready
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {

        $cacheKey = 'email';
        
        $cacheValue = $request->email;
        
        if($cacheValue == ''){
            return $next($request);
        }

        if (Cache::get($cacheKey) == $cacheValue) {
            return back()->with('error', tt_trans('Please wait a minute for another request', cons()::LANGUAGE_NOTIFICATION));
        }

        $response = $next($request);

        Cache::put($cacheKey, $cacheValue,  180);
        
        return $response;
    }
}
