<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Validation\ValidationException;
use Symfony\Component\HttpFoundation\Response;

class RestrictionRequestMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $isDemoModeActive = config('app.restriction_for_action');

        $doesNotallowedMethods = ['POST', 'PUT', 'PATCH', 'DELETE'];

        if (in_array($request->method(), $doesNotallowedMethods) && $isDemoModeActive) {
            throw ValidationException::withMessages([
                'error' => 'Demo mode is actived. Only GET requests are allowed.',
            ]);
        }

        return $next($request);
    }
}
