<?php

namespace App\Http\Requests\Backend\Auth;

use Illuminate\Foundation\Http\FormRequest;

class LoginRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            "email" => 'required',
            "password" => 'required',
            'remember' => 'nullable',
            'g-recaptcha-response' => [
                function ($attribute, $value, $fail) {
                    if (tc()->get('recaptcha_status') == cons()::ACTIVE && empty($value)) {
                        $fail(tt_trans('Google Recaptcha is required.', cons()::LANGUAGE_NOTIFICATION));
                    }
                },
            ],
        ];
    }
}
