<?php

namespace App\Http\Requests\Backend\Blog;

use Illuminate\Foundation\Http\FormRequest;

class BlogUpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {

        return [
            'category_id' => 'required',
            'tags' => 'required|array',
            'status' => 'required',
            'is_show_in_home' => 'required',
            'title' => 'required',
            'short_description' => 'required',
            'description' => 'required',
            'seo_tags' => 'required|array',
            'seo_description' => 'required',
            'image' => 'nullable|' . imageValidation(),
        ];
    }
}
