<?php

namespace App\Http\Requests\Backend\Category;

use App\Models\Category;
use Illuminate\Foundation\Http\FormRequest;

class CategoryRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {

        if (request()->category) {

            $category = Category::find(request()->category);

            return [
                'type' => 'required|in:script,image,url,video|unique:categories,type,' . $category->id,
                'ad_price' => 'required|numeric|gte:0',
                'admin_commission' => 'required|numeric|gte:0|lt:ad_price',
                'user_commission' => 'required|numeric|gte:0'
            ];
        }

        return [
            'type' => 'required|in:script,image,url,video|unique:categories,type',
            'ad_price' => 'required|numeric|gte:0',
            'admin_commission' => 'required|numeric|gte:0|lt:ad_price',
            'user_commission' => 'required|numeric|gte:0'
        ];
    }
}
