<?php

namespace App\Http\Requests\Backend\Cms;

use Illuminate\Foundation\Http\FormRequest;

class ContentUpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {

        $images = explode(',', $this->images);

        $rules = [
            'type' => 'required',
            'content.*' => 'required',
        ];

        foreach ($images as $image) {
            $rules[$image] = 'nullable|'.imageValidation();
        }

        return $rules;
    }

}
