<?php

namespace App\Http\Requests\Backend\Currency;

use Illuminate\Foundation\Http\FormRequest;

class StoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {

        return [
            "name" => "required|unique:currencies",
            'exchange_rate' => 'required|gt:0',
            "status" => "required",
            'icon' => 'required|' . imageValidation(),
            'currency_type' => 'required',
            'gateways' => 'required|array'
        ];
    }
}
