<?php

namespace App\Http\Requests\Backend\Currency;

use Illuminate\Foundation\Http\FormRequest;

class UpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {

        return [
            "name" => "required|unique:currencies,name," . $this->route('currency')->id,
            'exchange_rate' => 'required|gt:0',
            "status" => "required",
            'icon' => 'nullable|mimes:jpg,jpeg,png',
            'currency_type' => 'required',
            'gateways' => 'required|array'
        ];
    }
}
