<?php

namespace App\Http\Requests\Backend\Email;

use Illuminate\Foundation\Http\FormRequest;

class EmailConfigUpdate extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'email_configurations' => 'array',
            'email_configurations.*' => [
                function ($attribute, $value, $fail) {
                    if (tc()->get('is_smtp_mail') == cons()::ACTIVE && empty($value)) {
                        $fail(tt_trans(':attribute is needed when smtp mail on.', cons()::LANGUAGE_NOTIFICATION));
                    }
                },
            ],
        ];
    }
}
