<?php

namespace App\Http\Requests\Backend\Gateway;

use Illuminate\Foundation\Http\FormRequest;

class CreateGatewayRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            "name" => 'required|unique:gateways',
            "parameters" => 'array',
            'parameters.sending_options.*' => [
                function ($attribute, $value, $fail) {
                    if ($this->input('currency_type') == 'fiat' && empty($value)) {
                        $fail(tt_trans(':attribute field is required when currency type fiat.', cons()::LANGUAGE_NOTIFICATION));
                    }
                },
            ],
            'currency_type' => 'required',
            'parameters.details' => 'required',
            'parameters.proof.*.*' => 'required',
            "currency" => "required",
            "charge" => "required|numeric|gte:0",
            "type" => "required|numeric",
            "rate" => "required|numeric|gt:0",
            "image" => 'nullable|'.imageValidation()
        ];
    }
}
