<?php

namespace App\Http\Requests\Backend\Gateway;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class EditGatewayRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
           "name" => 'required|unique:gateways,name,'.$this->id,
            "parameters" => 'required|array',
            'parameters.sending_options.*' => [
                function ($attribute, $value, $fail) {
                    if ($this->input('currency_type') == 'fiat' && empty($value)) {
                        $fail(tt_trans(':attribute field is required when currency type fiat.', cons()::LANGUAGE_NOTIFICATION));
                    }
                },
            ],
            "currency" => "required",
            "currency_type" => "required",
            "charge" => "required|numeric|gte:0",
            'parameters.details' => 'required',
            'parameters.proof.*.*' => 'required',
            "type" => "required|numeric",
            "rate" => "required|numeric|gt:0",
            "image" => 'nullable|'.imageValidation()
        ];
    }
}
