<?php

namespace App\Http\Requests\Backend\Gateway;

use Illuminate\Foundation\Http\FormRequest;

class GatewayUpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            "parameters" => 'required|array',
            "currency" => "required",
            "charge" => "required|numeric|gte:0",
            "type" => "required|numeric",
            "rate" => "required|numeric|gt:0",
            "image" => 'nullable|'.imageValidation()
        ];
    }
}
