<?php

namespace App\Http\Requests\Backend\IcoSetting;

use Illuminate\Foundation\Http\FormRequest;

class IcoSettingRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {

        return [
            'token_name' => 'required',
            'token_symbol' => 'required',
            'currency_id' => 'required',
            'auction_buy_percentage' => 'required|gt:0',
            'auction_refund_percentage' => 'required|gt:0',
            'white_paper' => 'nullable|mimes:pdf',
            'icon' => 'nullable|mimes:jpeg,jpg,png',
        ];
    }
}
