<?php

namespace App\Http\Requests\Backend\Page;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Str;
class UpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'name' => 'required|unique:pages,name,'.$this->page->id,
            'slug' => 'required|unique:pages,slug,'.$this->page->id,
            'status' => 'nullable',
            'description' => 'nullable',
            'seo_keywords' => 'required|array',
            'seo_description' => 'required',
            'sections' => 'nullable',
            'is_description' => 'nullable'
        ];
    }

    protected function prepareForValidation(): void
    {
        $this->merge([
            'slug' => Str::slug($this->name),
            'is_description' => $this->description ? true :false,
        ]);
    }
}
