<?php

namespace App\Http\Requests\Backend\Referral;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class StoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'referral_setting_id' => 'required',
            'name' => [
                'required',
                Rule::unique('referral_levels')->where(function ($query){
                    return $query->where('referral_setting_id', request()->referral_setting_id);
                }),
            ],
            'image' => 'nullable|'.imageValidation(),
            'commission' =>'required|numeric|gt:0'
        ];
    }
}
