<?php

namespace App\Http\Requests\Backend\Settings;

use Illuminate\Foundation\Http\FormRequest;

class PluginRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {

        return [
            'facebook_status' => 'nullable',
            'facebook_app_id' => [
                function ($attribute, $value, $fail) {
                    if ($this->input('facebook_status') == 1 && empty($value)) {
                        $fail(tt_trans('The facebook App Id field is required when facebook App Id is on.', cons()::LANGUAGE_NOTIFICATION));
                    }
                },
            ],
            'facebook_app_secret' => [
                function ($attribute, $value, $fail) {
                    if ($this->input('facebook_status') == 1 && empty($value)) {
                        $fail(tt_trans('The Facebook app secret field is required when Facebook app secret is on.', cons()::LANGUAGE_NOTIFICATION));
                    }
                },
            ],

            'google_status' => 'nullable',
            'google_app_id' => [
                function ($attribute, $value, $fail) {
                    if ($this->input('google_status') == 1 && empty($value)) {
                        $fail(tt_trans('The google App Id field is required when google status is on.', cons()::LANGUAGE_NOTIFICATION));
                    }
                },
            ],
            'google_app_secret' => [
                function ($attribute, $value, $fail) {
                    if ($this->input('google_status') == 1 && empty($value)) {
                        $fail(tt_trans('The google app secret field is required when google app status is on.', cons()::LANGUAGE_NOTIFICATION));
                    }
                },
            ],

            'recaptcha_status' => 'nullable',
            'recaptcha_app_key' => [
                function ($attribute, $value, $fail) {
                    if ($this->input('recaptcha_status') == 1 && empty($value)) {
                        $fail(tt_trans('The recaptcha App Id field is required when recaptcha App Id is on.', cons()::LANGUAGE_NOTIFICATION));
                    }
                },
            ],
            'recaptcha_app_secret' => [
                function ($attribute, $value, $fail) {
                    if ($this->input('recaptcha_status') == 1 && empty($value)) {
                        $fail(tt_trans('The recaptcha app secret field is required when recaptcha app secret is on.', cons()::LANGUAGE_NOTIFICATION));
                    }
                },
            ],

            'infobip_status' => 'nullable',
            'infobip_username' => [
                function ($attribute, $value, $fail) {
                    if ($this->input('infobip_status') == 1 && empty($value)) {
                        $fail(tt_trans('The Infobip username field is required when app status is on.', cons()::LANGUAGE_NOTIFICATION));
                    }
                },
            ],
            'infobip_password' => [
                function ($attribute, $value, $fail) {
                    if ($this->input('infobip_status') == 1 && empty($value)) {
                        $fail(tt_trans('The infobip_password secret field is required when app status is on.', cons()::LANGUAGE_NOTIFICATION));
                    }
                },
            ],
            'infobip_sender_number' => [
                function ($attribute, $value, $fail) {
                    if ($this->input('infobip_status') == 1 && empty($value)) {
                        $fail(tt_trans('Sender number field is required when app status is on.', cons()::LANGUAGE_NOTIFICATION));
                    }
                },
            ],

            'tdio_status' => 'nullable',
            'tdio_url' => [
                function ($attribute, $value, $fail) {
                    if ($this->input('tdio_status') == 1 && empty($value)) {
                        $fail(tt_trans('The Tdio url field is required when tdio status on.', cons()::LANGUAGE_NOTIFICATION));
                    }
                },
            ],

            'analytics_status' => 'nullable',
            'analytics_id' => [
                function ($attribute, $value, $fail) {
                    if ($this->input('analytics_status') == 1 && empty($value)) {
                        $fail(tt_trans('The Analytics url field is required when analytics status on.', cons()::LANGUAGE_NOTIFICATION));
                    }
                },
            ],

            'pusher_status' => 'nullable',
            'pusher_app_key' => [
                function ($attribute, $value, $fail) {
                    if ($this->input('pusher_status') == 1 && empty($value)) {
                        $fail(tt_trans('The App key field is required when pusher status on.', cons()::LANGUAGE_NOTIFICATION));
                    }
                },
            ],

            'pusher_app_secret' => [
                function ($attribute, $value, $fail) {
                    if ($this->input('pusher_status') == 1 && empty($value)) {
                        $fail(tt_trans('The Secret field is required when pusher status on.', cons()::LANGUAGE_NOTIFICATION));
                    }
                },
            ],
            'pusher_app_id' => [
                function ($attribute, $value, $fail) {
                    if ($this->input('pusher_status') == 1 && empty($value)) {
                        $fail(tt_trans('The App id field is required when pusher status on.', cons()::LANGUAGE_NOTIFICATION));
                    }
                },
            ],
            'pusher_app_cluster' => [
                function ($attribute, $value, $fail) {
                    if ($this->input('pusher_status') == 1 && empty($value)) {
                        $fail(tt_trans('The App cluster field is required when pusher status on.', cons()::LANGUAGE_NOTIFICATION));
                    }
                },
            ],


            'ai_status' => 'nullable',
            'ai_key' => [
                function ($attribute, $value, $fail) {
                    if ($this->input('ai_status') == 1 && empty($value)) {
                        $fail(tt_trans('AI Key field is required when Ai Status is on.', cons()::LANGUAGE_NOTIFICATION));
                    }
                },
            ]
        ];
    }

    protected function prepareForValidation(): void
    {
        if ($this->facebook_status) {
            $this->merge([
                'facebook_status' => $this->facebook_status == 'on' ? 1 : 0,
            ]);
        } elseif ($this->google_status) {
            $this->merge([
                'google_status' => $this->google_status == 'on' ? 1 : 0,
            ]);
        } elseif ($this->recaptcha_status) {
            $this->merge([
                'recaptcha_status' => $this->recaptcha_status == 'on' ? 1 : 0,
            ]);
        } elseif ($this->infobip_status) {
            $this->merge([
                'infobip_status' => $this->infobip_status == 'on' ? 1 : 0,
            ]);
        } elseif ($this->tdio_status) {
            $this->merge([
                'tdio_status' => $this->tdio_status == 'on' ? 1 : 0,
            ]);
        } elseif ($this->analytics_status) {
            $this->merge([
                'analytics_status' => $this->analytics_status == 'on' ? 1 : 0,
            ]);
        } elseif ($this->pusher_status) {
            $this->merge([
                'pusher_status' => $this->pusher_status == 'on' ? 1 : 0,
            ]);
        }elseif ($this->ai_status) {
            $this->merge([
                'ai_status' => $this->ai_status == 'on' ? 1 : 0,
            ]);
        } else {
            $this->merge([
                $this->type . '_status' => $this->type . '_status' == 'on' ? 1 : 0,
            ]);
        }
    }
}
