<?php

namespace App\Http\Requests\Backend\Settings;

use Illuminate\Foundation\Http\FormRequest;

class SettingsRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            "sitename" => 'required',
            "currency" => 'required',
            'default_language' => 'required',
            "precision" => 'required|integer',
            "signup_bonus" => 'required|numeric',
            "withdraw_limit" => 'required|integer',
            "pagination" => 'required|integer',
            "timezone" => "required",
            "user_reg" => 'nullable',
            "email_ver" => "nullable",
            'strong_password' => 'nullable',
            "sms_ver" => "nullable",
            "kyc_ver" => "nullable",
            "preloader" => "nullable",
            "copyright" => "nullable",
            "maintanance_mode" => "nullable",
            "background" => 'nullable|'.imageValidation()
        ];
    }

    protected function prepareForValidation(): void
    {
        $this->merge([
            'email_ver' => $this->email_ver == 'on' ? 1 : 0,
            'sms_ver' => $this->sms_ver == 'on' ? 1 : 0,
            'kyc_ver' => $this->kyc_ver == 'on' ? 1 : 0,
            'preloader' => $this->preloader == 'on' ? 1 : 0,
            'user_reg' => $this->user_reg == 'on' ? 1 : 0,
            'strong_password' => $this->strong_password == 'on' ? 1 : 0,
            'recipient_otp' => $this->recipient_otp == 'on' ? 1 : 0,
            'maintanance_mode' => $this->maintanance_mode == 'on' ? 1 : 0,
        ]);
    }
}
