<?php

namespace App\Http\Requests\Backend\Staff;

use Illuminate\Foundation\Http\FormRequest;

class UpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            "username" => "required|unique:admins,username,".$this->admin,
            "email" => "required|email|unique:admins,email,".$this->admin,
            "password" => "nullable|confirmed",
            "roles" => 'required|array',
            "image" => 'nullable|image|mimes:jpg,png,jpeg,webp',
            'status' => 'required',
        ];
    }
}
