<?php

namespace App\Http\Requests\Backend\Stage;

use Illuminate\Foundation\Http\FormRequest;

class StoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {

        return [
            "title" => "required|unique:stages",
            'token_issues' => 'required|gt:0|integer',
            'base_price' => 'required|gt:0',
            'bonus_token' => 'nullable|gt:0',
            'soft_cap' => 'required|gt:0|integer|lte:hard_cap',
            'hard_cap' => 'required|gt:0|integer|gte:soft_cap',
            'start_date' => 'required|after_or_equal:today',
            'end_date' => 'required|after:start_date',
            'status' => 'required'
        ];
    }
}
