<?php

namespace App\Http\Requests\Backend\Stage;

use Illuminate\Foundation\Http\FormRequest;

class UpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {

        return [
            "title" => "required|unique:stages,title," . $this->route('stage')->id,
            'token_issues' => 'required|numeric|gt:0',
            'base_price' => 'required|gt:0',
            'bonus_token' => 'nullable|gt:0',
            'soft_cap' => 'required|gt:0',
            'hard_cap' => 'required|gt:0',
            'start_date' => 'required',
            'end_date' => 'required|after:start_date',
            'status' => 'required'
        ];
    }
}
