<?php

namespace App\Http\Requests\Backend\Theme;

use Illuminate\Foundation\Http\FormRequest;

class ThemeUpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'primary_color' => ['required', 'regex:/^#([a-f0-9]{6}|[a-f0-9]{3})$/i'],
            'secondary_color' => ['required', 'regex:/^#([a-f0-9]{6}|[a-f0-9]{3})$/i'],
            'theme' => 'required',
            'logo' => 'nullable|'.imageValidation(),
            'dark_logo' => 'nullable|'.imageValidation(),
            'icon' => 'nullable|'.imageValidation(),
            'heading_font' => 'required',
            'heading_font_family' => 'required',
            'paragraph_font' => 'required',
            'paragraph_font_family' => 'required'
        ];
    }
}
