<?php

namespace App\Http\Requests\Backend\Withdraw;

use Illuminate\Foundation\Http\FormRequest;

class StoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
       
        return [
            "name" => 'required|unique:withdraw_methods',
            "image" => 'required|'.imageValidation(),
            "currency" => 'required',
            "rate" => 'required|numeric|gt:0',
            "type" => "required",
            "charge" => 'required|numeric|gte:0',
            "min_amount" => 'required|numeric|gte:0',
            "max_amount" => 'required|numeric|gt:min_amount',
            "instruction" => 'required'
        ];
    }
}
