<?php

namespace App\Http\Requests\Frontend\Auction;

use Illuminate\Foundation\Http\FormRequest;

class AuctionCreateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'tokens' => 'required|gt:0|integer',
            'expected_profit_percentage' => 'required',
            'end_date' => 'required|after_or_equal:today'
        ];
    }
}
