<?php

namespace App\Http\Requests\Frontend\Auth;

use Illuminate\Foundation\Http\FormRequest;

class RegisterRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            "f_name" => 'required',
            "l_name" => 'required',
            "email" => 'required|email|unique:users',
            "mobile" => 'required|unique:users',
            "password" => passwordValidation(),
            'country' => 'required',
            'country_code' => 'nullable',
            'g-recaptcha-response' => [
                function ($attribute, $value, $fail) {
                    if (tc()->get('recaptcha_status') == cons()::ACTIVE && empty($value)) {
                        $fail(tt_trans('Google Recaptcha is required.', cons()::LANGUAGE_NOTIFICATION));
                    }
                },
            ],

        ];
    }

    protected function prepareForValidation(): void
    {
        $this->merge([
            'mobile' => $this->country_code.str_replace('-', '', $this->mobile)
        ]);
    }
}
