<?php

namespace App\Http\Requests\Frontend\Authorize;

use App\Models\KycSetting;
use Illuminate\Foundation\Http\FormRequest;

class KycVerficationRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $kyc = KycSetting::latest()->get();

        $validationRules = [];

        foreach ($kyc as $validation) {
            $imageValidation = '';
            if($validation->field_type == 'file'){
                $imageValidation = '|'.imageValidation();
            }
            $validationRules[$validation->field_name] = $validation->validation == 'required' ? 'required'.$imageValidation : 'nullable'.$imageValidation;
        }

        return $validationRules;
    }
}
