<?php

namespace App\Http\Requests\Frontend\Deposit;

use App\Models\CurrencyGateway;
use App\Models\Gateway;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\ValidationException;

class BankRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {

        $gateway = Gateway::find(session('transaction')['method_id']);


        $validationRules = [];

        if ($gateway->gateway_type == cons()::OFFLINE_GATEWAY) {

            foreach ($gateway->parameters->proof as $validation) {
                if ($validation->field_name != null) {
                    $imageValidation = '';
                    if ($validation->field_type == 'file') {
                        $imageValidation = '|' . imageValidation();
                    }
                    $validationRules['proof.' . $validation->field_name] = $validation->validation == 'required' ? 'required' . $imageValidation : 'nullable' . $imageValidation;
                }
            }
        }

        return $validationRules;
    }
}
