<?php

namespace App\Http\Requests\Frontend\Deposit;

use App\Models\CurrencyGateway;
use App\Models\Gateway;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\ValidationException;

class GatewayRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $gateway = Gateway::find($this->gateway_id);

        if(!$gateway){
           throw ValidationException::withMessages(['gateway_id' => tt_trans('Please select gateway',cons()::LANGUAGE_NOTIFICATION)]);
        }

        $validationRules = [];

        $validationRules['amount'] = 'required|numeric|gt:0';
        $validationRules['gateway_id'] = 'required';
        

        return $validationRules;
    }
}
