<?php

namespace App\Http\Requests\Frontend\Support;

use Illuminate\Foundation\Http\FormRequest;

class StoreReplyRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'message' => 'required',
            'files' => 'nullable',
            'files.*' => 'mimes:jpg,png,jpeg,doc,pdf,docx|max:1024'
        ];
    }
}
