<?php

namespace App\Listeners;

use App\Events\NotificationEvent;

class SendNotification
{
    public function handle(NotificationEvent $event)
    {

        $collection = $event->collection;
        $user = $event->user;
        $message = $event->message;
        $template = emailTemplate($event->action);
        $setting = mailTemplate($event->action);


        if (!$template || !$setting) {
            return;
        }

        $configuration = $setting['configuration'];

        if ($configuration['notification']) {


            sendNotification([
                'receiver' => $configuration['notification_receiver'],
                'type' => $configuration['notification_type'],
                'message' => isset($configuration['form_mail']) ? $message['message'] : $message,
                'url' => str_replace(':id', $collection->id, $configuration['route']),
                'user' => $user,
            ]);
        }

        if ($configuration['push']) {
            pushNotification(
                [
                    'user_id' => $user->id,
                    'message' => isset($configuration['form_mail']) ? $message['message'] : $message,
                    'type' => $configuration['response_type'],
                ],
                $configuration['notification_receiver'],
            );
        }


        if ($configuration['email']) {

            $status = $collection->status == cons()::PENDING ? 'Pending' : ($collection->status == cons()::REJECTED ? 'Rejected' : 'Approved');

            $data = [];


            if ($template) {

                foreach ($setting['codes'] as $key => $value) {
                    if ($template->general_mail && !isset($configuration['form_mail'])) {
                        $data[$key] = $message;
                    } else {
                        $columnName = $template->relatable_table[$key] ?? null;
                        $isFormattable = in_array($key, $template->formattable_column ?? []);

                        $value = $columnName ? $collection->$key->$columnName : $collection->$key;
                        $data[$key] = $isFormattable ? formatter($value, true) : $value;
                    }
                }
            }

            if (isset($configuration['form_mail'])) {
                $data['subject'] = $message['subject'];
                $data['message'] = $message['message'];
            }




            $data['user'] = $user->username;
            $data['time'] = now();
            $data['status'] = $status;


            sendMail($user->email, $data, emailTemplate($event->action));
        }
    }
}
